<?php

if (!current_user_can(get_option($this->shared->get('slug') . "_tables_menu_capability"))) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'dalt'));
}

//if the temporary tables are more than 100 clear the older (first inserted) temporary table
$this->delete_older_temporary_table();

//delete a table
if (isset($_POST['delete_id'])) {

    global $wpdb;
    $delete_id = intval($_POST['delete_id'], 10);

    //delete this table
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
    $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE id = %d ", $delete_id);
    $query_result_1 = $wpdb->query($safe_sql);

    //delete all the rows of this table
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
    $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d ", $delete_id);
    $query_result_2 = $wpdb->query($safe_sql);

    //delete all the cells of this table
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
    $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d ", $delete_id);
    $query_result_3 = $wpdb->query($safe_sql);

    if ($query_result_1 !== false and $query_result_2 !== false and $query_result_3 !== false) {
        $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_html__('The table has been successfully deleted.', 'dalt') . '</p></div>';
    }

}

//clone the table
if (isset($_POST['clone_id'])) {

    global $wpdb;
    $clone_id = intval($_POST['clone_id'], 10);

    //clone the table
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
    $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE id = $clone_id");
    $wpdb->query("UPDATE tmptable_1 SET id = NULL");
    $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
    $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");
    $last_inserted_id = $wpdb->insert_id;

    //clone the rows
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
    $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE table_id = $clone_id");
    $wpdb->query("UPDATE tmptable_1 SET table_id = $last_inserted_id");
    $wpdb->query("UPDATE tmptable_1 SET id = NULL");
    $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
    $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

    //clone the cells
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
    $wpdb->query("CREATE TEMPORARY TABLE tmptable_1 SELECT * FROM $table_name WHERE table_id = $clone_id");
    $wpdb->query("UPDATE tmptable_1 SET table_id = $last_inserted_id");
    $wpdb->query("UPDATE tmptable_1 SET id = NULL");
    $wpdb->query("INSERT INTO $table_name SELECT * FROM tmptable_1");
    $wpdb->query("DROP TEMPORARY TABLE IF EXISTS tmptable_1");

}

//get the table data
$display_form = true;
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id'], 10);
    global $wpdb;
    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
    $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE temporary = 0 AND id = %d", $edit_id);
    $table_obj = $wpdb->get_row($safe_sql);
    if ($table_obj === null) {
        $display_form = false;
    }
}

?>

<!-- output -->

<div class="wrap">

    <?php if ($this->shared->get_number_of_tables() > 0) : ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_html_e('League Table - Tables', 'dalt'); ?></h2>

            <form action="admin.php" method="get">
                <input type="hidden" name="page" value="dalt-tables">
                <?php
                if (isset($_GET['s'])) {
	                $s = sanitize_text_field($_GET['s']);
	                if(strlen(trim($s)) > 0){
		                $search_string = $s;
	                }else{
		                $search_string = '';
	                }
                } else {
	                $search_string = '';
                }
                ?>
                <input type="text" name="s" placeholder="<?php esc_attr_e('Search...', 'dalt'); ?>"
                       value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
                <input type="submit" value="">
            </form>

        </div>

    <?php else: ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_html_e('League Table - Tables', 'dalt'); ?></h2>

        </div>

    <?php endif; ?>

    <div id="daext-menu-wrapper">

        <?php

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s'])) {
	        $search_string = sanitize_text_field($_GET['s']);
            global $wpdb;
            $filter = $wpdb->prepare('AND (id LIKE %s OR name LIKE %s OR description LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%', '%' . $search_string . '%');
        } else {
            $filter = '';
        }

        //retrieve the total number of tables
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $total_items = $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE temporary = 0 $filter");

        //Initialize the pagination class
        require_once($this->shared->get('dir') . '/admin/inc/class-dalt-pagination.php');
        $pag = new dalt_pagination();
        $pag->set_total_items($total_items);//Set the total number of items
        $pag->set_record_per_page(10); //Set records per page
        $pag->set_target_page("admin.php?page=" . $this->shared->get('slug') . "-tables");//Set target page
        $pag->set_current_page();//set the current page number from $_GET

        ?>

        <!-- Query the database -->
        <?php
        $query_limit = $pag->query_limit();
        $results = $wpdb->get_results("SELECT * FROM $table_name WHERE temporary = 0 $filter ORDER BY id DESC $query_limit", ARRAY_A); ?>

        <?php if (count($results) > 0) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                    <tr>
                        <th>
                            <div><?php esc_html_e('Name', 'dalt'); ?></div>
                        </th>
                        <th>
                            <div><?php esc_html_e('Description', 'dalt'); ?></div>
                        </th>
                        <th>
                            <div><?php esc_html_e( 'Shortcode', 'dalt' ); ?></div>
                        </th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach ($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_html(stripslashes($result['name'])); ?></td>
                            <td><?php echo esc_html(stripslashes($result['description'])); ?></td>
                            <td><?php echo '[lt id="' . intval($result['id'], 10) . '"]'; ?></td>
                            <td class="icons-container">
                                <form method="POST"
                                      action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-tables">
                                    <input type="hidden" name="clone_id" value="<?php echo $result['id']; ?>">
                                    <input class="menu-icon clone help-icon" type="submit" value="">
                                </form>
                                <a class="menu-icon edit"
                                   href="admin.php?page=<?php echo $this->shared->get('slug'); ?>-tables&edit_id=<?php echo $result['id']; ?>"></a>
                                <form method="POST" id="form-delete-<?php echo intval($result['id'], 10); ?>" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-tables">
                                    <input type="hidden" value="<?php echo $result['id']; ?>" name="delete_id">
                                    <input class="menu-icon delete" type="submit" value="">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

            <!-- Display the pagination -->
            <?php if ($pag->total_items > 0) : ?>
                <div class="daext-tablenav daext-clearfix">
                    <div class="daext-tablenav-pages">
						<span
                                class="daext-displaying-num"><?php echo $pag->total_items; ?>
                            &nbsp<?php esc_attr_e('items', 'dalt'); ?></span>
                        <?php $pag->show(); ?>
                    </div>
                </div>
            <?php endif; ?>

        <?php endif; ?>

        <div class="table-container">

            <?php if ($display_form) : ?>

                <?php if (isset($_GET['edit_id'])) : ?>

                    <!-- Edit Table -->

                    <div class="daext-form-container">

                        <div class="daext-form-title"><?php esc_html_e('Edit Table', 'dalt'); ?></div>

                        <table class="daext-form daext-form-table">

                            <input type="hidden" id="update-id" value="<?php echo $table_obj->id; ?>"/>

                            <!-- Name -->
                            <tr>
                                <th><label for="name"><?php esc_html_e('Name', 'dalt'); ?></label></th>
                                <td>
                                    <input value="<?php echo esc_attr(stripslashes($table_obj->name)); ?>" type="text"
                                           id="name" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The name of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Description -->
                            <tr>
                                <th><label
                                            for="description"><?php esc_html_e('Description', 'dalt'); ?></label></th>
                                <td>
                                    <input value="<?php echo esc_attr(stripslashes($table_obj->description)); ?>"
                                           type="text" id="description" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The description of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Rows -->
                            <tr>
                                <th><label for="rows"><?php esc_html_e('Rows', 'dalt'); ?></label></th>
                                <td>
                                    <input value="<?php echo intval($table_obj->rows, 10); ?>" type="text" value="10"
                                           id="rows"
                                           maxlength="5" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('To define the number of rows please enter a number included between 1 and 10000.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Columns -->
                            <tr>
                                <th><label for="columns"><?php esc_html_e('Columns', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->columns, 10); ?>" type="text" value="10"
                                           id="columns"
                                           maxlength="2" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('To define the number of columns please enter a number included between 1 and 40.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th><label for="data"><?php esc_html_e('Data', 'dalt'); ?></label></th>
                                <td id="dalt-table-td">
                                    <div id="dalt-table"></div>
                                </td>
                            </tr>

                            <!-- Sorting Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="sorting-options">
                                <th class="group-title"><?php esc_html_e('Sorting', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Enable Sorting -->
                            <tr class="sorting-options">
                                <th><label
                                            for="enable-sorting"><?php esc_html_e('Enable Sorting', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-sorting">
                                        <option
                                                value="0" <?php selected(intval($table_obj->enable_sorting), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->enable_sorting), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table will be sorted based on the criteria defined in this section.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Enable Manual Sorting -->
                            <tr class="sorting-options">
                                <th><label
                                            for="enable-manual-sorting"><?php esc_html_e('Enable Manual Sorting', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-manual-sorting">
                                        <option
                                                value="0" <?php selected(intval($table_obj->enable_manual_sorting), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->enable_manual_sorting), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option enables the users to manually sort the table by clicking on the table header. Please note that manual sorting will not be applied if the "Enable Sorting" option is disabled.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Show Position -->
                            <tr class="sorting-options">
                                <th><label
                                            for="show-position"><?php esc_html_e('Show Position', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="show-position">
                                        <option
                                                value="0" <?php selected(intval($table_obj->show_position), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->show_position), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('If enabled, the position column will be automatically generated.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Position Side -->
                            <tr class="sorting-options">
                                <th><label
                                            for="position-side"><?php esc_html_e('Position Side', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="position-side">
                                        <option
                                                value="left" <?php selected($table_obj->position_side, 'left'); ?>><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option
                                                value="right" <?php selected($table_obj->position_side, 'right'); ?>><?php esc_html_e('Right', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the position column should be generated on the left side or on the right side of the table.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Position Label -->
                            <tr class="sorting-options">
                                <th><label
                                            for="position-label"><?php esc_html_e('Position Label', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php esc_attr_e(stripslashes($table_obj->position_label)) ?>"
                                           id="position-label" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the text that should be displayed in the header of the position column.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Number Format -->
                            <tr class="sorting-options">
                                <th><label
                                            for="number-format"><?php esc_html_e('Number Format', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="number-format">
                                        <option
                                                value="0" <?php selected(intval($table_obj->number_format), '0'); ?>><?php esc_html_e('EU', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->number_format), '1'); ?>><?php esc_html_e('US', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the decimal mark (the symbol used to separate the integer part from the fractional part of a decimal number) in use is the comma (EU) or the point (US). This option affects how the "Currency" data type is sorted.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <?php

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Order Desc Asc <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-desc-asc-<?php echo $i; ?>"><?php echo esc_html__('Order (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-desc-asc-<?php echo $i; ?>">
                                            <option
                                                    value="0" <?php selected(intval($table_obj->{'order_desc_asc_' . $i}), 0); ?>><?php esc_html_e('Disabled', 'dalt'); ?></option>
                                            <option
                                                    value="1" <?php selected(intval($table_obj->{'order_desc_asc_' . $i}), 1); ?>><?php esc_html_e('Descending', 'dalt'); ?></option>
                                            <option
                                                    value="2" <?php selected(intval($table_obj->{'order_desc_asc_' . $i}), 2); ?>><?php esc_html_e('Ascending', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('This option allows you to enable (in descending or ascending order) or disable the order.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order By <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-by-<?php echo $i; ?>"><?php echo esc_html__('Order By (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-by-<?php echo $i; ?>">
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('This option allows you to determine for which column the order should be applied.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order Data Type <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-data-type-<?php echo $i; ?>"><?php echo esc_html__('Order Data Type (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-data-type-<?php echo $i; ?>">
                                            <option
                                                    value="auto" <?php selected($table_obj->{'order_data_type_' . $i}, 'auto'); ?>><?php esc_html_e('Auto', 'dalt'); ?></option>
                                            <option
                                                    value="text" <?php selected($table_obj->{'order_data_type_' . $i}, 'text'); ?>><?php esc_html_e('Text', 'dalt'); ?></option>
                                            <option
                                                    value="digit" <?php selected($table_obj->{'order_data_type_' . $i}, 'digit'); ?>><?php esc_html_e('Digit', 'dalt'); ?></option>
                                            <option
                                                    value="percent" <?php selected($table_obj->{'order_data_type_' . $i}, 'percent'); ?>><?php esc_html_e('Percent', 'dalt'); ?></option>
                                            <option
                                                    value="currency" <?php selected($table_obj->{'order_data_type_' . $i}, 'currency'); ?>><?php esc_html_e('Currency', 'dalt'); ?></option>
                                            <option
                                                    value="url" <?php selected($table_obj->{'order_data_type_' . $i}, 'url'); ?>><?php esc_html_e('URL', 'dalt'); ?></option>
                                            <option
                                                    value="time" <?php selected($table_obj->{'order_data_type_' . $i}, 'time'); ?>><?php esc_html_e('Time', 'dalt'); ?></option>
                                            <option
                                                    value="isoDate" <?php selected($table_obj->{'order_data_type_' . $i}, 'isoDate'); ?>><?php esc_html_e('ISO Date', 'dalt'); ?></option>
                                            <option
                                                    value="usLongDate" <?php selected($table_obj->{'order_data_type_' . $i}, 'usLongDate'); ?>><?php esc_html_e('US Long Date', 'dalt'); ?></option>
                                            <option
                                                    value="shortDate" <?php selected($table_obj->{'order_data_type_' . $i}, 'shortDate'); ?>><?php esc_html_e('Short Date', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('Select the type of data included in the column that determines the order. Please note that if you leave "Auto" the type of data will be automatically determined by the sorting system.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order Date Format <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-date-format-<?php echo $i; ?>"><?php echo esc_html__('Order Date Format (Priority', 'dalt') . ' ' . $i . esc_html(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-date-format-<?php echo $i; ?>">
                                            <option
                                                    value="ddmmyyyy" <?php selected($table_obj->{'order_date_format_' . $i}, 'ddmmyyyy'); ?>><?php esc_html_e('DDMMYYYY', 'dalt'); ?></option>
                                            <option
                                                    value="yyyymmdd" <?php selected($table_obj->{'order_date_format_' . $i}, 'yyyymmdd'); ?>><?php esc_html_e('YYYYMMDD', 'dalt'); ?></option>
                                            <option
                                                    value="mmddyyyy" <?php selected($table_obj->{'order_date_format_' . $i}, 'mmddyyyy'); ?>><?php esc_html_e('MMDDYYYY', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Use this option to set the data format of the column that determines the order. Please note that this option will be considered only if the corresponding "Order Data Type" option is set to "Short Date".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            ?>

                            <!-- Style Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="style-options">
                                <th class="group-title"><?php esc_html_e('Style', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Table Layout -->
                            <tr class="style-options">
                                <th><label
                                            for="table-layout"><?php esc_html_e('Table Layout', 'dalt'); ?></label></th>
                                <td>
                                    <select id="table-layout">
                                        <option
                                                value="0" <?php selected(intval($table_obj->table_layout, 10), 0); ?>><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->table_layout, 10), 1); ?>><?php esc_html_e('Fixed', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select the algorithm used to lay out the table.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Table Width -->
                            <tr class="style-options">
                                <th><label
                                            for="table-width"><?php esc_html_e('Table Width', 'dalt'); ?></label></th>
                                <td>
                                    <select id="table-width">
                                        <option
                                                value="0" <?php selected(intval($table_obj->table_width, 10), 0); ?>><?php esc_html_e('Full Width', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->table_width, 10), 1); ?>><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option
                                                value="2" <?php selected(intval($table_obj->table_width, 10), 2); ?>><?php esc_html_e('Specified Value', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With "Full Width" the table width will be equal to the width of the container, with "Auto" the table width will be determined automatically based on the table content, with "Specified Value" the table width will be determined by the value entered in the "Table Width Value" field.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Table Width Value -->
                            <tr class="style-options">
                                <th><label
                                            for="table-width-value"><?php esc_html_e('Table Width Value', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php echo intval($table_obj->table_width_value, 10); ?>"
                                           id="table-width-value" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the width of the table. Please note that this option will be used only if the "Table Width" option is set to "Specified Value".', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Minimum Width -->
                            <tr class="style-options">
                                <th><label
                                            for="table-minimum-width"><?php esc_html_e('Table Minimum Width', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php echo intval($table_obj->table_minimum_width, 10); ?>" id="table-minimum-width" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the minimum width of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Column Width -->
                            <tr class="style-options">
                                <th><label for="column-width"><?php esc_html_e('Column Width', 'dalt'); ?></label></th>
                                <td>
                                    <select id="column-width">
                                        <option value="0" <?php selected(intval($table_obj->column_width, 10), 0); ?>><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option value="1" <?php selected(intval($table_obj->column_width, 10), 1); ?>><?php esc_html_e('Specified Value', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the width of the columns should be automatically determined or based on the values provided in the "Column Width Value" field.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Column Width Value -->
                            <tr class="style-options">
                                <th><label
                                            for="column-width-value"><?php esc_html_e('Column Width Value', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php echo esc_attr(stripslashes($table_obj->column_width_value)); ?>"
                                           id="column-width-value" maxlength="2000" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column widths, separated by a comma. If only one column width is provided the single value will be applied to all the columns.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Enable Container -->
                            <tr class="style-options">
                                <th><label
                                            for="enable-container"><?php esc_html_e('Enable Container', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-container">
                                        <option
                                                value="0" <?php selected(intval($table_obj->enable_container, 10), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->enable_container, 10), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Enable this option to include the table in a container. With this feature enabled and the proper values in the "Container Width" and "Container Height" options you will be able to generate a table with an horizontal and/or a vertical scrolling bar.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Container Width -->
                            <tr class="style-options">
                                <th><label
                                            for="container-width"><?php esc_html_e('Container Width', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php echo intval($table_obj->container_width, 10); ?>"
                                           id="container-width" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the width of the container or 0 if you want the width of the container automatically determined. This option will be considered only if the "Enable Container" option is enabled.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Container Height -->
                            <tr class="style-options">
                                <th><label
                                            for="container-height"><?php esc_html_e('Container Height', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="<?php echo intval($table_obj->container_height, 10); ?>"
                                           id="container-height" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the height of the container or 0 if you want the height of the container automatically determined. This option will be considered only if the "Enable Container" option is enabled.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Margin Top -->
                            <tr class="style-options">
                                <th><label
                                            for="table-margin-top"><?php esc_html_e('Table Margin Top', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->table_margin_top, 10); ?>" type="text"
                                           value="20" id="table-margin-top" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the top margin of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Margin Bottom -->
                            <tr class="style-options">
                                <th><label
                                            for="table-margin-bottom"><?php esc_html_e('Table Margin Bottom', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->table_margin_bottom, 10); ?>"
                                           type="text"
                                           value="20" id="table-margin-bottom" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the bottom margin of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Show Header -->
                            <tr class="style-options">
                                <th><label
                                            for="show-header"><?php esc_html_e('Show Header', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="show-header">
                                        <option
                                                value="0" <?php selected(intval($table_obj->show_header), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->show_header), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table header will be displayed.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Sticky Header -->
                            <tr class="style-options">
                                <th><label
                                            for="sticky-header"><?php esc_html_e('Sticky Header', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="sticky-header">
                                        <option
                                                value="0" <?php selected(intval($table_obj->sticky_header), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->sticky_header), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table header will be sticky.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Font Size -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-size"><?php esc_html_e('Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->header_font_size, 10); ?>" type="text"
                                           value="6" id="header-font-size" maxlength="3" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font size of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Family -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-family"><?php esc_html_e('Header Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e(stripslashes($table_obj->header_font_family)); ?>"
                                           type="text" value="'Open Sans', Helvetica, Arial, sans-serif"
                                           id="header-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-weight"><?php esc_html_e('Header Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-font-weight">
                                        <option
                                                value="100" <?php selected($table_obj->header_font_weight, '100'); ?>><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option
                                                value="200" <?php selected($table_obj->header_font_weight, '200'); ?>><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option
                                                value="300" <?php selected($table_obj->header_font_weight, '300'); ?>><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option
                                                value="400" <?php selected($table_obj->header_font_weight, '400'); ?>><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option
                                                value="500" <?php selected($table_obj->header_font_weight, '500'); ?>><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option
                                                value="600" <?php selected($table_obj->header_font_weight, '600'); ?>><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option
                                                value="700" <?php selected($table_obj->header_font_weight, '700'); ?>><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option
                                                value="800" <?php selected($table_obj->header_font_weight, '800'); ?>><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option
                                                value="900" <?php selected($table_obj->header_font_weight, '900'); ?>><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the header.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-style"><?php esc_html_e('Header Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-font-style">
                                        <option
                                                value="normal" <?php selected($table_obj->header_font_style, 'normal'); ?>><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option
                                                value="italic" <?php selected($table_obj->header_font_style, 'italic'); ?>><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option
                                                value="oblique" <?php selected($table_obj->header_font_style, 'oblique'); ?>><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the header.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Position Alignment -->
                            <tr class="style-options">
                                <th><label for="header-position-alignment"><?php esc_html_e('Header Position Alignment', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-position-alignment">
                                        <option value="left" <?php selected($table_obj->header_position_alignment, 'left'); ?>><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option value="center" <?php selected($table_obj->header_position_alignment, 'center'); ?>><?php esc_html_e('Center', 'dalt'); ?></option>
                                        <option value="right" <?php selected($table_obj->header_position_alignment, 'right'); ?>><?php esc_html_e('Right', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('The alignment of the text displayed in the header of the position column.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Background Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-background-color"><?php esc_html_e('Header Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->header_background_color); ?>"
                                           class="wp-color-picker" type="text" id="header-background-color"
                                           maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-color"><?php esc_html_e('Header Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->header_font_color); ?>"
                                           class="wp-color-picker" type="text" value="#FFFFFF" id="header-font-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-link-color"><?php esc_html_e('Header Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->header_link_color); ?>"
                                           class="wp-color-picker" type="text" value="#FFFFFF" id="header-link-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text used for the links in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Border Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-border-color"><?php esc_html_e('Header Border Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->header_border_color); ?>"
                                           class="wp-color-picker" type="text" id="header-border-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the borders in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Size -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-size"><?php esc_html_e('Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->body_font_size, 10); ?>" type="text"
                                           id="body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font size of the text displayed in the body.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Family -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-family"><?php esc_html_e('Body Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e(stripslashes($table_obj->body_font_family)); ?>"
                                           type="text" id="body-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the body.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-weight"><?php esc_html_e('Body Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="body-font-weight">
                                        <option
                                                value="100" <?php selected($table_obj->body_font_weight, '100'); ?>><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option
                                                value="200" <?php selected($table_obj->body_font_weight, '200'); ?>><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option
                                                value="300" <?php selected($table_obj->body_font_weight, '300'); ?>><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option
                                                value="400" <?php selected($table_obj->body_font_weight, '400'); ?>><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option
                                                value="500" <?php selected($table_obj->body_font_weight, '500'); ?>><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option
                                                value="600" <?php selected($table_obj->body_font_weight, '600'); ?>><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option
                                                value="700" <?php selected($table_obj->body_font_weight, '700'); ?>><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option
                                                value="800" <?php selected($table_obj->body_font_weight, '800'); ?>><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option
                                                value="900" <?php selected($table_obj->body_font_weight, '900'); ?>><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the body.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Body Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-style"><?php esc_html_e('Body Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="body-font-style">
                                        <option
                                                value="normal" <?php selected($table_obj->body_font_style, 'normal'); ?>><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option
                                                value="italic" <?php selected($table_obj->body_font_style, 'italic'); ?>><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option
                                                value="oblique" <?php selected($table_obj->body_font_style, 'oblique'); ?>><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the body.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Even Rows Bg Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-background-color"><?php esc_html_e('Even Rows Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->even_rows_background_color); ?>"
                                           class="wp-color-picker" type="text" id="even-rows-background-color"
                                           maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Background Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-bg-color"><?php esc_html_e('Odd Rows Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->odd_rows_background_color); ?>"
                                           class="wp-color-picker" type="text" id="odd-rows-background-color"
                                           maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Even Rows Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-font-color"><?php esc_html_e('Even Rows Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->even_rows_font_color); ?>"
                                           class="wp-color-picker" type="text" id="even-rows-font-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-font-color"><?php esc_html_e('Odd Rows Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->odd_rows_font_color); ?>"
                                           class="wp-color-picker" type="text" id="odd-rows-font-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Even Rows Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-link-color"><?php esc_html_e('Even Rows Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->even_rows_link_color); ?>"
                                           class="wp-color-picker" type="text" id="even-rows-link-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed for the links of the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-link-color"><?php esc_html_e('Odd Rows Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->odd_rows_link_color); ?>"
                                           class="wp-color-picker" type="text" id="odd-rows-link-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed for the links of the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Rows Border Color -->
                            <tr class="style-options">
                                <th><label
                                            for="rows-border-color"><?php esc_html_e('Rows Border Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->rows_border_color); ?>"
                                           class="wp-color-picker" type="text" id="rows-border-color" maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the border color of the rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Show Caption -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-show-caption"><?php esc_html_e('Show Caption', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-show-caption">
                                        <option
                                                value="0" <?php selected(intval($table_obj->caption_show_caption), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->caption_show_caption), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Enable this option to include the table caption in the layout.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Side -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-caption-side"><?php esc_html_e('Caption Side', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-caption-side">
                                        <option
                                                value="0" <?php selected(intval($table_obj->caption_caption_side), 0); ?>><?php esc_html_e('Top', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->caption_caption_side), 1); ?>><?php esc_html_e('Bottom', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the side of the table caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Text Align -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-text-align"><?php esc_html_e('Caption Text Align', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-text-align">
                                        <option
                                                value="0" <?php selected(intval($table_obj->caption_text_align), 0); ?>><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->caption_text_align), 1); ?>><?php esc_html_e('Center', 'dalt'); ?></option>
                                        <option
                                                value="2" <?php selected(intval($table_obj->caption_text_align), 2); ?>><?php esc_html_e('Right', 'dalt'); ?></option>
                                        <option
                                                value="3" <?php selected(intval($table_obj->caption_text_align), 3); ?>><?php esc_html_e('Justify', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the horizontal alignment of the table caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Size -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-size"><?php esc_html_e('Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->caption_font_size, 10); ?>" type="text"
                                           id="caption-font-size" maxlength="5" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font size of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Caption Font Family -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-family"><?php esc_html_e('Caption Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e(stripslashes($table_obj->caption_font_family)); ?>"
                                           type="text" value="'Open Sans', Helvetica, Arial, sans-serif"
                                           id="caption-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Caption Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-weight"><?php esc_html_e('Caption Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-font-weight">
                                        <option
                                                value="100" <?php selected($table_obj->caption_font_weight, '100'); ?>><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option
                                                value="200" <?php selected($table_obj->caption_font_weight, '200'); ?>><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option
                                                value="300" <?php selected($table_obj->caption_font_weight, '300'); ?>><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option
                                                value="400" <?php selected($table_obj->caption_font_weight, '400'); ?>><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option
                                                value="500" <?php selected($table_obj->caption_font_weight, '500'); ?>><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option
                                                value="600" <?php selected($table_obj->caption_font_weight, '600'); ?>><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option
                                                value="700" <?php selected($table_obj->caption_font_weight, '700'); ?>><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option
                                                value="800" <?php selected($table_obj->caption_font_weight, '800'); ?>><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option
                                                value="900" <?php selected($table_obj->caption_font_weight, '900'); ?>><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-style"><?php esc_html_e('Caption Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-font-style">
                                        <option
                                                value="normal" <?php selected($table_obj->caption_font_style, 'normal'); ?>><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option
                                                value="italic" <?php selected($table_obj->caption_font_style, 'italic'); ?>><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option
                                                value="oblique" <?php selected($table_obj->caption_font_style, 'oblique'); ?>><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-color"><?php esc_html_e('Caption Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php esc_attr_e($table_obj->caption_font_color); ?>"
                                           class="wp-color-picker" type="text" id="caption-font-color"
                                           maxlength="7"
                                           size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autocolors Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="autocolors-options">
                                <th
                                    class="group-title"><?php esc_html_e('Autocolors', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Autocolors Priority -->
                            <tr class="autocolors-options">
                                <th><label
                                            for="autocolors-priority"><?php esc_html_e('Autocolors Priority', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="autocolors-priority">
                                        <option
                                                value="rows" <?php selected($table_obj->autocolors_priority, 'rows'); ?>><?php esc_html_e('Rows', 'dalt'); ?></option>
                                        <option
                                                value="columns" <?php selected($table_obj->autocolors_priority, 'columns'); ?>><?php esc_html_e('Columns', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option determines which category of autocolors has the priority.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <?php

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Autocolors Affected Rows <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-affected-rows-<?php echo $i; ?>"><?php echo esc_html__('Affected Rows (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_affected_rows_' . $i})); ?>"
                                               id="autocolors-affected-rows-<?php echo $i; ?>" maxlength="2000"
                                               size="30" autocomplete="off"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the "Style', 'dalt') . ' ' . $i . esc_attr__('" should be applied.', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Rows Background Color <?php echo $i; ?>  -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-rows-background-color-<?php echo $i; ?>"><?php echo esc_html__('Rows Background Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_rows_background_color_' . $i})); ?>"
                                               id="autocolors-rows-background-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the background color applied to the rows affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Rows Font Color <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-rows-font-color-<?php echo $i; ?>"><?php echo esc_html__('Rows Font Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_rows_font_color_' . $i})); ?>"
                                               id="autocolors-rows-font-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the color of the text applied to the rows affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Autocolors Affected Columns <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-affected-columns-<?php echo $i; ?>"><?php echo esc_html__('Affected Columns (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_affected_columns_' . $i})); ?>"
                                               id="autocolors-affected-columns-<?php echo $i; ?>" maxlength="110"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the "Style', 'dalt') . ' ' . $i . esc_attr__('" should be applied.', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Columns Background Color <?php echo $i; ?>  -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-columns-background-color-<?php echo $i; ?>"><?php echo esc_html__('Columns Background Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_columns_background_color_' . $i})); ?>"
                                               id="autocolors-columns-background-color-<?php echo $i; ?>" maxlength="7"
                                               size="30" autocomplete="off"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the background color applied to the columns affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Columns Font Color <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-columns-font-color-<?php echo $i; ?>"><?php echo esc_html__('Columns Font Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text"
                                               value="<?php echo esc_attr(stripslashes($table_obj->{'autocolors_columns_font_color_' . $i})); ?>"
                                               id="autocolors-columns-font-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the color of the text applied to the columns affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            ?>

                            <!-- Autoalignment Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="autoalignment-options">
                                <th
                                    class="group-title"><?php esc_html_e('Autoalignment', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Priority -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-priority"><?php esc_html_e('Autoalignment Priority', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="autoalignment-priority">
                                        <option
                                                value="rows" <?php selected($table_obj->autoalignment_priority, 'rows'); ?>><?php esc_html_e('Rows', 'dalt'); ?></option>
                                        <option
                                                value="columns" <?php selected($table_obj->autoalignment_priority, 'columns'); ?>><?php esc_html_e('Columns', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option determines which category of autoalignment has the priority.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Left -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-left"><?php echo esc_html__('Affected Rows (Left)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_rows_left)); ?>"
                                           id="autoalignment-affected-rows-left" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the left alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Center -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-center"><?php echo esc_html__('Affected Rows (Center)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_rows_center)); ?>"
                                           id="autoalignment-affected-rows-center" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the center alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Right -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-right"><?php echo esc_html__('Affected Rows (Right)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_rows_right)); ?>"
                                           id="autoalignment-affected-rows-right" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the right alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Left -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-left"><?php echo esc_html__('Affected Columns (Left)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_columns_left)); ?>"
                                           id="autoalignment-affected-columns-left" maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the left alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Center -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-center"><?php echo esc_html__('Affected Columns (Center)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_columns_center)); ?>"
                                           id="autoalignment-affected-columns-center" maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the center alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Right -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-right"><?php echo esc_html__('Affected Columns (Right)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text"
                                           value="<?php echo esc_attr(stripslashes($table_obj->autoalignment_affected_columns_right)); ?>"
                                           id="autoalignment-affected-columns-right" maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the right alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Responsive Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="responsive-options">
                                <th
                                    class="group-title"><?php esc_html_e('Responsive', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Tablet Breakpoint -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-breakpoint"><?php esc_html_e('Tablet Breakpoint', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->tablet_breakpoint, 10); ?>" type="text"
                                           id="tablet-breakpoint" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('When the browser viewport width goes below this value the device will be considered a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Hide Tablet List -->
                            <tr class="responsive-options">
                                <th><label
                                            for="hide-tablet-list"><?php esc_html_e('Tablet Hide List', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo esc_attr_e(stripslashes($table_obj->hide_tablet_list)); ?>" type="text"
                                           id="hide-tablet-list" maxlength="110" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column indexes, separated by a comma, that you want to hide when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Header Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-header-font-size"><?php esc_html_e('Tablet Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->tablet_header_font_size, 10); ?>"
                                           type="text" id="tablet-header-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table header when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Body Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-body-font-size"><?php esc_html_e('Tablet Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->tablet_body_font_size, 10); ?>"
                                           type="text" id="tablet-body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table body when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Caption Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-caption-font-size"><?php esc_html_e('Tablet Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->tablet_caption_font_size, 10); ?>"
                                           type="text" id="tablet-caption-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the caption when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Hide Images -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-hide-images"><?php esc_html_e('Tablet Hide Images', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="tablet-hide-images">
                                        <option
                                                value="0" <?php selected(intval($table_obj->tablet_hide_images), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->tablet_hide_images), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" if you want to hide all the images included in the cells when the device is a tablet.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Phone Breakpoint -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-breakpoint"><?php esc_html_e('Phone Breakpoint', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->phone_breakpoint, 10); ?>" type="text"
                                           id="phone-breakpoint" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('When the browser viewport width goes below this value the device will be considered a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Hide Phone List -->
                            <tr class="responsive-options">
                                <th><label
                                            for="hide-phone-list"><?php esc_html_e('Phone Hide List', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo esc_attr_e(stripslashes($table_obj->hide_phone_list)); ?>" type="text"
                                           id="hide-phone-list" maxlength="110" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column indexes, separated by a comma, that you want to hide when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Header Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-header-font-size"><?php esc_html_e('Phone Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->phone_header_font_size, 10); ?>"
                                           type="text" id="phone-header-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table header when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Body Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-body-font-size"><?php esc_html_e('Phone Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->phone_body_font_size, 10); ?>"
                                           type="text"
                                           id="phone-body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table body when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Caption Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-caption-font-size"><?php esc_html_e('Phone Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->phone_caption_font_size, 10); ?>"
                                           type="text"
                                           id="phone-caption-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the caption when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Hide Images -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-hide-images"><?php esc_html_e('Phone Hide Images', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="phone-hide-images">
                                        <option
                                                value="0" <?php selected(intval($table_obj->phone_hide_images), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->phone_hide_images), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" if you want to hide all the images included in the cells when the device is a phone.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Advanced Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="advanced-options">
                                <th
                                    class="group-title"><?php esc_html_e('Advanced', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Enable Cell Properties -->
                            <tr class="advanced-options">
                                <th><label
                                            for="enable-cell-properties"><?php esc_html_e('Enable Cell Properties', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-cell-properties">
                                        <option
                                                value="0" <?php selected(intval($table_obj->enable_cell_properties), 0); ?>><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option
                                                value="1" <?php selected(intval($table_obj->enable_cell_properties), 1); ?>><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" to use the cell properties or "No" to ignore the cell properties and improve the performance. When the cell properties are disabled the time required to generate the table HTML with PHP and the time required to render the table with the browser will be reduced.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Formula Average Decimals -->
                            <tr class="advanced-options">
                                <th><label
                                            for="formula-average-decimals"><?php esc_html_e('Formula Average Decimals', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="<?php echo intval($table_obj->formula_average_decimals, 10); ?>"
                                           type="text" id="formula-average-decimals" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the number of decimal digits available in the result of the "Average" formula.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Formula Average Round -->
                            <tr class="advanced-options">
                                <th><label
                                            for="formula-average-round"><?php esc_html_e('Formula Average Round', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="formula-average-round">
                                        <option
                                                value="1" <?php selected(intval($table_obj->formula_average_round, 10), 1); ?>><?php esc_html_e('PHP_ROUND_HALF_UP', 'dalt'); ?></option>
                                        <option
                                                value="2" <?php selected(intval($table_obj->formula_average_round, 10), 2); ?>><?php esc_html_e('PHP_ROUND_HALF_DOWN', 'dalt'); ?></option>
                                        <option
                                                value="3" <?php selected(intval($table_obj->formula_average_round, 10), 3); ?>><?php esc_html_e('PHP_ROUND_HALF_EVEN', 'dalt'); ?></option>
                                        <option
                                                value="4" <?php selected(intval($table_obj->formula_average_round, 10), 4); ?>><?php esc_html_e('PHP_ROUND_HALF_ODD', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Specify the mode in which rounding occurs in the result of the "Average" formula.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption -->
                            <tr class="advanced-options">
                                <th><label
                                            for="caption"><?php esc_html_e('Caption', 'dalt'); ?></label></th>
                                <td>
                                    <input value="<?php echo esc_attr(stripslashes($table_obj->caption)); ?>"
                                           type="text" id="caption" maxlength="2000" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The caption of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                        </table>

                        <!-- Submit Button -->
                        <div class="daext-form-action">
                            <input id="save" data-reload-menu="0" class="button" type="submit"
                                   value="<?php esc_attr_e('Update Table', 'dalt'); ?>">
                            <input id="close" data-reload-menu="0" class="button" type="submit"
                                   value="<?php esc_attr_e('Close', 'dalt'); ?>">
                        </div>

                    </div>

                <?php else : ?>

                    <!-- Create New Table -->

                    <?php

                    //create temporary table in db table
                    global $wpdb;
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
                    $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
	                        temporary = %d,
	                        name = %s,
	                        `rows` = %d,
	                        columns = %d",
                        1,
                        '[TEMPORARY]',
                        10,
                        10);
                    $result = $wpdb->query($safe_sql);

                    //get the automatic id of the inserted element
                    $temporary_table_id = $wpdb->insert_id;

                    //initialize the data based on the initial number of rows and columns
                    $this->initialize_table_data($temporary_table_id, 11, 10);

                    ?>

                    <div class="daext-form-container">

                        <div class="daext-form-title"><?php esc_html_e('Create Table', 'dalt'); ?></div>

                        <table class="daext-form daext-form-table">

                            <input type="hidden" id="temporary-table-id"
                                   value="<?php echo $temporary_table_id; ?>"/>

                            <!-- Name -->
                            <tr>
                                <th><label for="name"><?php esc_html_e('Name', 'dalt'); ?></label></th>
                                <td>
                                    <input type="text" id="name" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The name of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Description -->
                            <tr>
                                <th><label
                                            for="description"><?php esc_html_e('Description', 'dalt'); ?></label></th>
                                <td>
                                    <input type="text" id="description" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The description of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Rows -->
                            <tr>
                                <th><label for="rows"><?php esc_html_e('Rows', 'dalt'); ?></label></th>
                                <td>
                                    <input type="text" value="10" id="rows"
                                           maxlength="5" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('To define the number of rows please enter a number included between 1 and 10000.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Columns -->
                            <tr>
                                <th><label for="columns"><?php esc_html_e('Columns', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="10" id="columns"
                                           maxlength="2" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('To define the number of columns please enter a number included between 1 and 40.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <tr valign="top">
                                <th><label for="data"><?php esc_html_e('Data', 'dalt'); ?></label></th>
                                <td id="dalt-table-td">
                                    <div id="dalt-table"></div>
                                </td>
                            </tr>

                            <!-- Sorting Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="sorting-options">
                                <th class="group-title"><?php esc_attr_e('Sorting', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Enable Sorting -->
                            <tr class="sorting-options">
                                <th><label
                                            for="enable-sorting"><?php esc_html_e('Enable Sorting', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-sorting">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table will be sorted based on the criteria defined in this section.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Enable Manual Sorting -->
                            <tr class="sorting-options">
                                <th><label
                                            for="enable-manual-sorting"><?php esc_html_e('Enable Manual Sorting', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-manual-sorting">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option enables the users to manually sort the table by clicking on the table header. Please note that manual sorting will not be applied if the "Enable Sorting" option is disabled.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Show Position -->
                            <tr class="sorting-options">
                                <th><label
                                            for="show-position"><?php esc_html_e('Show Position', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="show-position">
                                        <option value="0" selected="selected"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the position column will be automatically generated.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Position Side -->
                            <tr class="sorting-options">
                                <th><label
                                            for="position-side"><?php esc_html_e('Position Side', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="position-side">
                                        <option value="left"
                                                selected="selected"><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option value="right"><?php esc_html_e('Right', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the position column should be generated on the left side or on the right side of the table.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Position Label -->
                            <tr class="sorting-options">
                                <th><label
                                            for="position-label"><?php esc_html_e('Position Label', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="#" id="position-label" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the text that should be displayed in the header of the position column.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Number Format -->
                            <tr class="sorting-options">
                                <th><label
                                            for="number-format"><?php esc_html_e('Number Format', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="number-format">
                                        <option value="0"
                                                selected="selected"><?php esc_html_e('EU', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('US', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the decimal mark (the symbol used to separate the integer part from the fractional part of a decimal number) in use is the comma (EU) or the point (US). This option affects how the "Currency" data type is sorted.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <?php

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Order Desc Asc <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-desc-asc-<?php echo $i; ?>"><?php echo esc_html__('Order (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-desc-asc-<?php echo $i; ?>">
                                            <option value="0"><?php esc_html_e('Disabled', 'dalt'); ?></option>
                                            <option value="1"><?php esc_html_e('Descending', 'dalt'); ?></option>
                                            <option value="2"><?php esc_html_e('Ascending', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('This option allows you to enable (in descending or ascending order) or disable the order.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order By <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-by-1"><?php echo esc_html__('Order By (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-by-<?php echo $i; ?>">
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('This option allows you to determine for which column the order should be applied.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order Data Type <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-data-type-<?php echo $i; ?>"><?php echo esc_html__('Order Data Type (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-data-type-<?php echo $i; ?>">
                                            <option value="auto"><?php esc_html_e('Auto', 'dalt'); ?></option>
                                            <option value="text"><?php esc_html_e('Text', 'dalt'); ?></option>
                                            <option value="digit"><?php esc_html_e('Digit', 'dalt'); ?></option>
                                            <option value="percent"><?php esc_html_e('Percent', 'dalt'); ?></option>
                                            <option value="currency"><?php esc_html_e('Currency', 'dalt'); ?></option>
                                            <option value="url"><?php esc_html_e('URL', 'dalt'); ?></option>
                                            <option value="time"><?php esc_html_e('Time', 'dalt'); ?></option>
                                            <option value="isoDate"><?php esc_html_e('ISO Date', 'dalt'); ?></option>
                                            <option
                                                    value="usLongDate"><?php esc_html_e('US Long Date', 'dalt'); ?></option>
                                            <option value="shortDate"><?php esc_html_e('Short Date', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title='<?php esc_attr_e('Select the type of data included in the column that determines the order. Please note that if you leave "Auto" the type of data will be automatically determined by the sorting system.', 'dalt'); ?>'></div>
                                    </td>
                                </tr>

                                <!-- Order Date Format <?php echo $i; ?> -->
                                <tr class="sorting-options">
                                    <th><label
                                                for="order-date-format-<?php echo $i; ?>"><?php echo esc_html__('Order Date Format (Priority', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <select id="order-date-format-<?php echo $i; ?>">
                                            <option value="ddmmyyyy"><?php esc_html_e('DDMMYYYY', 'dalt'); ?></option>
                                            <option value="yyyymmdd"><?php esc_html_e('YYYYMMDD', 'dalt'); ?></option>
                                            <option value="mmddyyyy"><?php esc_html_e('MMDDYYYY', 'dalt'); ?></option>
                                        </select>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr_e('Use this option to set the data format of the column that determines the order. Please note that this option will be considered only if the corresponding "Order Data Type" option is set to "Short Date".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            ?>

                            <!-- Style Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="style-options">
                                <th class="group-title"><?php esc_html_e('Style', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Table Layout -->
                            <tr class="style-options">
                                <th><label for="table-layout"><?php esc_html_e('Table Layout', 'dalt'); ?></label></th>
                                <td>
                                    <select id="table-layout">
                                        <option value="0"><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Fixed', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select the algorithm used to lay out the table.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Table Width -->
                            <tr class="style-options">
                                <th><label
                                            for="table-width"><?php esc_html_e('Table Width', 'dalt'); ?></label></th>
                                <td>
                                    <select id="table-width">
                                        <option value="0"><?php esc_html_e('Full Width', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option value="2"><?php esc_html_e('Specified Value', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With "Full Width" the table width will be equal to the width of the container, with "Auto" the table width will be determined automatically based on the table content, with "Specified Value" the table width will be determined by the value entered in the "Table Width Value" field.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Table Width Value -->
                            <tr class="style-options">
                                <th><label
                                            for="table-width-value"><?php esc_html_e('Table Width Value', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="400" id="table-width-value" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the width of the table. Please note that this option will be used only if the "Table Width" option is set to "Specified Value".', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Minimum Width -->
                            <tr class="style-options">
                                <th><label
                                            for="table-minimum-width"><?php esc_html_e('Table Minimum Width', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="0" id="table-minimum-width" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the minimum width of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Column Width -->
                            <tr class="style-options">
                                <th><label
                                            for="column-width"><?php esc_html_e('Column Width', 'dalt'); ?></label></th>
                                <td>
                                    <select id="column-width">
                                        <option value="0"><?php esc_html_e('Auto', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Specified Value', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select if the width of the columns should be automatically determined or based on the values provided in the "Column Width Value" field.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Column Width Value -->
                            <tr class="style-options">
                                <th><label
                                            for="column-width-value"><?php esc_html_e('Column Width Value', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="100" id="column-width-value" maxlength="2000" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column widths, separated by a comma. If only one column width is provided the single value will be applied to all the columns.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Enable Container -->
                            <tr class="style-options">
                                <th><label
                                            for="enable-container"><?php esc_html_e('Enable Container', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-container">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Enable this option to include the table in a container. With this feature enabled and the proper values in the "Container Width" and "Container Height" options you will be able to generate a table with an horizontal and/or a vertical scrolling bar.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Container Width -->
                            <tr class="style-options">
                                <th><label
                                            for="container-width"><?php esc_html_e('Container Width', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="400" id="container-width" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the width of the container or 0 if you want the width of the container automatically determined. This option will be considered only if the "Enable Container" option is enabled.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Container Height -->
                            <tr class="style-options">
                                <th><label
                                            for="container-height"><?php esc_html_e('Container Height', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="400" id="container-height" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the height of the container or 0 if you want the height of the container automatically determined. This option will be considered only if the "Enable Container" option is enabled.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Margin Top -->
                            <tr class="style-options">
                                <th><label
                                            for="table-margin-top"><?php esc_html_e('Table Margin Top', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="20" id="table-margin-top" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the top margin of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Table Margin Bottom -->
                            <tr class="style-options">
                                <th><label
                                            for="table-margin-bottom"><?php esc_html_e('Table Margin Bottom', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="20" id="table-margin-bottom" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the bottom margin of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Show Header -->
                            <tr class="style-options">
                                <th><label
                                            for="show-header"><?php esc_html_e('Show Header', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="show-header">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"
                                                selected="selected"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table header will be displayed.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Sticky Header -->
                            <tr class="style-options">
                                <th><label
                                            for="sticky-header"><?php esc_html_e('Sticky Header', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="sticky-header">
                                        <option value="0" selected="selected"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('With this option enabled the table header will be sticky.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Font Size -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-size"><?php esc_html_e('Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="header-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font size of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Family -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-family"><?php esc_html_e('Header Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="'Open Sans', Helvetica, Arial, sans-serif"
                                           id="header-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-style"><?php esc_html_e('Header Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-font-weight">
                                        <option value="100"><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option value="200"><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option value="300"><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option value="400"
                                                selected="selected"><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option value="500"><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option value="600"><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option value="700"><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option value="800"><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option value="900"><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the header.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-style"><?php esc_html_e('Header Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-font-style">
                                        <option value="normal"
                                                selected="selected"><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option value="italic"><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option value="oblique"><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the header.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Position Alignment -->
                            <tr class="style-options">
                                <th><label
                                            for="header-position-alignment"><?php esc_html_e('Header Position Alignment', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="header-position-alignment">
                                        <option value="left"><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option value="center" selected="selected"><?php esc_html_e('Center', 'dalt'); ?></option>
                                        <option value="right"><?php esc_html_e('Right', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('The alignment of the text displayed in the header of the position column.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Header Background Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-background-color"><?php esc_html_e('Header Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#C3512F"
                                           id="header-background-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-font-color"><?php esc_html_e('Header Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#FFFFFF" id="header-font-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-link-color"><?php esc_html_e('Header Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#FFFFFF" id="header-link-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text used for the links in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Header Border Color -->
                            <tr class="style-options">
                                <th><label
                                            for="header-border-color"><?php esc_html_e('Header Border Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#B34A2A" id="header-border-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the borders in the header.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Size -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-size"><?php esc_html_e('Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font size of the text displayed in the body.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Family -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-family"><?php esc_html_e('Body Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="'Open Sans', Helvetica, Arial, sans-serif"
                                           id="body-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the body.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Body Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-weight"><?php esc_html_e('Body Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="body-font-weight">
                                        <option value="100"><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option value="200"><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option value="300"><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option value="400"
                                                selected="selected"><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option value="500"><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option value="600"><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option value="700"><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option value="800"><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option value="900"><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the body.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Body Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="body-font-style"><?php esc_html_e('Body Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="body-font-style">
                                        <option value="normal"
                                                selected="selected"><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option value="italic"><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option value="oblique"><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the body.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Even Rows Bg Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-bg-color"><?php esc_html_e('Even Rows Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#FFFFFF"
                                           id="even-rows-background-color" maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Bg Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-bg-color"><?php esc_html_e('Odd Rows Background Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#FCFCFC"
                                           id="odd-rows-background-color" maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the background color of the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Even Rows Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-font-color"><?php esc_html_e('Even Rows Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#666666" id="even-rows-font-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-font-color"><?php esc_html_e('Odd Rows Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#666666" id="odd-rows-font-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Even Rows Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="even-rows-link-color"><?php esc_html_e('Even Rows Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#C3512F" id="even-rows-link-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed for the links of the even rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Odd Rows Link Color -->
                            <tr class="style-options">
                                <th><label
                                            for="odd-rows-link-color"><?php esc_html_e('Odd Rows Link Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#C3512F" id="odd-rows-link-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed for the links of the odd rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Rows Border Color -->
                            <tr class="style-options">
                                <th><label
                                            for="rows-border-color"><?php esc_html_e('Rows Border Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#E1E1E1" id="rows-border-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the border color of the rows.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Show Caption -->
                            <tr class="style-options">
                                <th><label for="caption-show-caption"><?php esc_html_e('Show Caption', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-show-caption">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1" selected="selected"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Enable this option to include the table caption in the layout.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Side -->
                            <tr class="style-options">
                                <th><label for="caption-caption-side"><?php esc_html_e('Caption Side', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-caption-side">
                                        <option value="0"><?php esc_html_e('Top', 'dalt'); ?></option>
                                        <option value="1" selected="selected"><?php esc_html_e('Bottom', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the side of the table caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Text Align -->
                            <tr class="style-options">
                                <th><label for="caption-text-align"><?php esc_html_e('Text Align', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-text-align">
                                        <option value="0"><?php esc_html_e('Left', 'dalt'); ?></option>
                                        <option value="1" selected="selected"><?php esc_html_e('Center', 'dalt'); ?></option>
                                        <option value="2"><?php esc_html_e('Right', 'dalt'); ?></option>
                                        <option value="3"><?php esc_html_e('Justify', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon" title='<?php esc_attr_e('Set the horizontal alignment of the table caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Size -->
                            <tr class="style-options">
                                <th><label for="caption-font-size"><?php esc_html_e('Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="caption-font-size" maxlength="5" size="30" autocomplete="off"/>
                                    <div class="help-icon" title="<?php esc_attr_e('Set the font size of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Caption Font Family -->
                            <tr class="style-options">
                                <th><label for="caption-font-family"><?php esc_html_e('Caption Font Family', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="'Open Sans', Helvetica, Arial, sans-serif"
                                           id="caption-font-family" maxlength="255" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the font family of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Caption Font Weight -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-weight"><?php esc_html_e('Caption Font Weight', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-font-weight">
                                        <option value="100"><?php esc_html_e('100', 'dalt'); ?></option>
                                        <option value="200"><?php esc_html_e('200', 'dalt'); ?></option>
                                        <option value="300"><?php esc_html_e('300', 'dalt'); ?></option>
                                        <option value="400"
                                                selected="selected"><?php esc_html_e('400', 'dalt'); ?></option>
                                        <option value="500"><?php esc_html_e('500', 'dalt'); ?></option>
                                        <option value="600"><?php esc_html_e('600', 'dalt'); ?></option>
                                        <option value="700"><?php esc_html_e('700', 'dalt'); ?></option>
                                        <option value="800"><?php esc_html_e('800', 'dalt'); ?></option>
                                        <option value="900"><?php esc_html_e('900', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font weight of the text displayed in the caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Style -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-style"><?php esc_html_e('Caption Font Style', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="caption-font-style">
                                        <option value="normal"
                                                selected="selected"><?php esc_html_e('Normal', 'dalt'); ?></option>
                                        <option value="italic"><?php esc_html_e('Italic', 'dalt'); ?></option>
                                        <option value="oblique"><?php esc_html_e('Oblique', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Set the font style of the text displayed in the caption.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption Font Color -->
                            <tr class="style-options">
                                <th><label
                                            for="caption-font-color"><?php esc_html_e('Caption Font Color', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input class="wp-color-picker" type="text" value="#666666"
                                           id="caption-font-color"
                                           maxlength="7" size="30"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Set the color of the text displayed in the caption.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autocolors Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="autocolors-options">
                                <th
                                    class="group-title"><?php esc_html_e('Autocolors', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Autocolors Priority -->
                            <tr class="autocolors-options">
                                <th><label
                                            for="autocolors-priority"><?php esc_html_e('Autocolors Priority', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="autocolors-priority">
                                        <option value="rows"><?php esc_html_e('Rows', 'dalt'); ?></option>
                                        <option value="columns"><?php esc_html_e('Columns', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option determines which category of autocolors has the priority.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <?php

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Autocolors Affected Rows <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-affected-rows-<?php echo $i; ?>"><?php echo esc_html__('Affected Rows (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text" value="" id="autocolors-affected-rows-<?php echo $i; ?>"
                                               maxlength="2000"
                                               size="30" autocomplete="off"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the "Style', 'dalt') . ' ' . $i . esc_attr__('" should be applied.', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Rows Background Color <?php echo $i; ?>  -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-rows-background-color-<?php echo $i; ?>"><?php echo esc_html__('Rows Background Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text" value="#FFFFFF"
                                               id="autocolors-rows-background-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the background color applied to the rows affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Rows Font Color <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-rows-font-color-<?php echo $i; ?>"><?php echo esc_html__('Rows Font Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text" value="#666666"
                                               id="autocolors-rows-font-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the color of the text applied to the rows affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            for ($i = 1; $i <= 5; $i++) {

                                ?>

                                <!-- Autocolors Affected Columns <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-affected-columns-<?php echo $i; ?>"><?php echo esc_html__('Affected Columns (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input type="text" value="" id="autocolors-affected-columns-<?php echo $i; ?>"
                                               maxlength="110"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the "Style', 'dalt') . ' ' . $i . esc_attr__('" should be applied.', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Columns Background Color <?php echo $i; ?>  -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-columns-background-color-<?php echo $i; ?>"><?php echo esc_html__('Columns Background Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text" value="#FFFFFF"
                                               id="autocolors-columns-background-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the background color applied to the columns affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <!-- Autocolors Columns Font Color <?php echo $i; ?> -->
                                <tr class="autocolors-options">
                                    <th><label
                                                for="autocolors-columns-font-color-<?php echo $i; ?>"><?php echo esc_html__('Columns Font Color (Style', 'dalt') . ' ' . $i . esc_html__(')', 'dalt'); ?></label>
                                    </th>
                                    <td>
                                        <input class="wp-color-picker" type="text" value="#666666"
                                               id="autocolors-columns-font-color-<?php echo $i; ?>" maxlength="7"
                                               size="30"/>
                                        <div class="help-icon"
                                             title="<?php echo esc_attr__('Select the color of the text applied to the columns affected by "Style', 'dalt') . ' ' . $i . esc_attr__('".', 'dalt'); ?>"></div>
                                    </td>
                                </tr>

                                <?php

                            }

                            ?>

                            <!-- Autoalignment Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="autoalignment-options">
                                <th
                                    class="group-title"><?php esc_html_e('Autoalignment', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Priority -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-priority"><?php esc_html_e('Autoalignment Priority', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="autoalignment-priority">
                                        <option value="rows"><?php esc_html_e('Rows', 'dalt'); ?></option>
                                        <option value="columns"><?php esc_html_e('Columns', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('This option determines which category of autoalignment has the priority.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Left -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-left"><?php echo esc_html__('Affected Rows (Left)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-rows-left" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the left alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Center -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-center"><?php echo esc_html__('Affected Rows (Center)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-rows-center" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the center alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Rows Right -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-rows-right"><?php echo esc_html__('Affected Rows (Right)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-rows-right" maxlength="2000"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of row indexes, separated by a comma, where the right alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Left -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-left"><?php echo esc_html__('Affected Columns (Left)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-columns-left" maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the left alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Center -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-center"><?php echo esc_html__('Affected Columns (Center)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-columns-center"
                                           maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the center alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Autoalignment Affected Columns Right -->
                            <tr class="autoalignment-options">
                                <th><label
                                            for="autoalignment-affected-columns-right"><?php echo esc_html__('Affected Columns (Right)', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="autoalignment-affected-columns-right"
                                           maxlength="110"
                                           size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php echo esc_attr__('Enter a list of column indexes, separated by a comma, where the right alignment should be applied.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Responsive Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="responsive-options">
                                <th
                                    class="group-title"><?php esc_html_e('Responsive', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Tablet Breakpoint -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-breakpoint"><?php esc_html_e('Tablet Breakpoint', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="989" id="tablet-breakpoint" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('When the browser viewport width goes below this value the device will be considered a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Hide Tablet List -->
                            <tr class="responsive-options">
                                <th><label
                                            for="hide-tablet-list"><?php esc_html_e('Hide Tablet List', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="hide-tablet-list" maxlength="110" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column indexes, separated by a comma, that you want to hide when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Header Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-header-font-size"><?php esc_html_e('Tablet Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="tablet-header-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table header when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Body Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-body-font-size"><?php esc_html_e('Tablet Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="tablet-body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table body when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Caption Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-caption-font-size"><?php esc_html_e('Tablet Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="tablet-caption-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the caption when the device is a tablet.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Tablet Hide Images -->
                            <tr class="responsive-options">
                                <th><label
                                            for="tablet-hide-images"><?php esc_html_e('Tablet Hide Images', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="tablet-hide-images">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" if you want to hide all the images included in the cells when the device is a tablet.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Phone Breakpoint -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-breakpoint"><?php esc_html_e('Phone Breakpoint', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="479" id="phone-breakpoint" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('When the browser viewport width goes below this value the device will be considered a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Hide Phone List -->
                            <tr class="responsive-options">
                                <th><label
                                            for="hide-phone-list"><?php esc_html_e('Hide Phone List', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="" id="hide-phone-list" maxlength="110" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter a list of column indexes, separated by a comma, that you want to hide when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Header Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-header-font-size"><?php esc_html_e('Phone Header Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="phone-header-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table header when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Body Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-body-font-size"><?php esc_html_e('Phone Body Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="phone-body-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the cells in the table body when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Body Font Size -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-caption-font-size"><?php esc_html_e('Phone Caption Font Size', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input type="text" value="11" id="phone-caption-font-size" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the font size applied to the caption when the device is a phone.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Phone Hide Images -->
                            <tr class="responsive-options">
                                <th><label
                                            for="phone-hide-images"><?php esc_html_e('Phone Hide Images', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="phone-hide-images">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" if you want to hide all the images included in the cells when the device is a phone.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Advanced Options ---------------------------------------------- -->
                            <tr class="group-trigger" data-trigger-target="advanced-options">
                                <th
                                    class="group-title"><?php esc_html_e('Advanced', 'dalt'); ?></th>
                                <td>
                                    <div class="expand-icon"></div>
                                </td>
                            </tr>

                            <!-- Enable Cell Properties -->
                            <tr class="advanced-options">
                                <th><label
                                            for="enable-cell-properties"><?php esc_html_e('Enable Cell Properties', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="enable-cell-properties">
                                        <option value="0"><?php esc_html_e('No', 'dalt'); ?></option>
                                        <option value="1"
                                                selected="selected"><?php esc_html_e('Yes', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Select "Yes" to use the cell properties or "No" to ignore the cell properties and improve the performance. When the cell properties are disabled the time required to generate the table HTML with PHP and the time required to render the table with the browser will be reduced.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Formula Average Decimals -->
                            <tr class="advanced-options">
                                <th><label
                                            for="formula-average-decimals"><?php esc_html_e('Formula Average Decimals', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <input value="2" type="text" id="formula-average-decimals" maxlength="6" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('Enter the number of decimal digits available in the result of the "Average" formula.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                            <!-- Formula Average Round -->
                            <tr class="advanced-options">
                                <th><label
                                            for="formula-average-round"><?php esc_html_e('Formula Average Round', 'dalt'); ?></label>
                                </th>
                                <td>
                                    <select id="formula-average-round">
                                        <option value="1"
                                                selected="selected"><?php esc_html_e('PHP_ROUND_HALF_UP', 'dalt'); ?></option>
                                        <option value="2"><?php esc_html_e('PHP_ROUND_HALF_DOWN', 'dalt'); ?></option>
                                        <option value="3"><?php esc_html_e('PHP_ROUND_HALF_EVEN', 'dalt'); ?></option>
                                        <option value="4"><?php esc_html_e('PHP_ROUND_HALF_ODD', 'dalt'); ?></option>
                                    </select>
                                    <div class="help-icon"
                                         title='<?php esc_attr_e('Specify the mode in which rounding occurs in the result of the "Average" formula.', 'dalt'); ?>'></div>
                                </td>
                            </tr>

                            <!-- Caption -->
                            <tr class="advanced-options">
                                <th><label for="caption"><?php esc_html_e('Caption', 'dalt'); ?></label></th>
                                <td>
                                    <input type="text" id="caption" maxlength="2000" size="30" autocomplete="off"/>
                                    <div class="help-icon"
                                         title="<?php esc_attr_e('The caption of the table.', 'dalt'); ?>"></div>
                                </td>
                            </tr>

                        </table>

                        <!-- Submit Button -->
                        <div class="daext-form-action">
                            <input id="save" data-reload-menu="1" class="button" type="submit"
                                   value="<?php esc_attr_e('Add Table', 'dalt'); ?>">
                        </div>

                    </div>

                <?php endif; ?>

                <div id="table-error" class="error settings-error notice below-h2"><p></p></div>
                <div id="table-success" class="updated settings-error notice below-h2"><p></p></div>

            <?php endif; ?>

        </div>

        <div id="sidebar-container">

            <div class="daext-form-container">

                <h3 class="daext-form-title" id="cell-properties-title"><?php esc_html_e('Body', 'dalt'); ?>
                    &nbsp1:1</h3>

                <table class="daext-form daext-form-cell-properties">

                    <tbody>

                    <!-- Cell Index Hidden Fields -->
                    <input type="hidden" id="cell-property-row-index" value="1">
                    <input type="hidden" id="cell-property-column-index" value="0">

                    <!-- Text Color -->
                    <tr class="cell-property<?php
                    if(intval(get_option($this->shared->get('slug') . "_enable_text_color_cell_property"), 10) === 0){
                        echo ' display-none';
                    }
                    ?>" id="cell-property-text-color-container">
                        <th><label
                                    for="cell-property-text-color"><?php esc_html_e('Text Color', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input value="" class="wp-color-picker" maxlength="7" type="text"
                                   id="cell-property-text-color">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The color of the text in the cell.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Background Color -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_background_color_cell_property"), 10) === 0){echo ' display-none';} ?>" id="cell-property-background-color-container">
                        <th><label
                                    for="cell-property-background-color"><?php esc_html_e('Background Color', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input value="" class="wp-color-picker" maxlength="7" type="text"
                                   id="cell-property-background-color">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The background color of the cell.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Alignment -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_alignment_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-alignment"><?php esc_html_e('Alignment', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-alignment">
                                <option value="left"><?php esc_html_e('Left', 'dalt'); ?></option>
                                <option value="center"
                                        selected="selected"><?php esc_html_e('Center', 'dalt'); ?></option>
                                <option value="right"><?php esc_html_e('Right', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The alignment of the text in the cell.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Font Weight -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_font_weight_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-font-weight"><?php esc_html_e('Font Weight', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-font-weight">
                                <option value="100"><?php esc_html_e('100', 'dalt'); ?></option>
                                <option value="200"><?php esc_html_e('200', 'dalt'); ?></option>
                                <option value="300"><?php esc_html_e('300', 'dalt'); ?></option>
                                <option value="400" selected="selected"><?php esc_html_e('400', 'dalt'); ?></option>
                                <option value="500"><?php esc_html_e('500', 'dalt'); ?></option>
                                <option value="600"><?php esc_html_e('600', 'dalt'); ?></option>
                                <option value="700"><?php esc_html_e('700', 'dalt'); ?></option>
                                <option value="800"><?php esc_html_e('800', 'dalt'); ?></option>
                                <option value="900"><?php esc_html_e('900', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The font weight of the text in the cell.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Font Style -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_font_style_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-font-style"><?php esc_html_e('Font Style', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-font-style">
                                <option value="normal"
                                        selected="selected"><?php esc_html_e('Normal', 'dalt'); ?></option>
                                <option value="italic"><?php esc_html_e('Italic', 'dalt'); ?></option>
                                <option value="oblique"><?php esc_html_e('Oblique', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The font style of the text in the cell.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Link -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_link_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label for="cell-property-link"><?php esc_html_e('Link', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="2083" type="text" id="cell-property-link" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Enter an URL to link the text of the cell to a specific destination.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Link Color -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_link_color_cell_property"), 10) === 0){echo ' display-none';} ?>" id="cell-property-link-color-container">
                        <th><label
                                    for="cell-property-link-color"><?php esc_html_e('Link Color', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input value="" class="wp-color-picker" maxlength="7" type="text"
                                   id="cell-property-link-color">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The color of the text used for the links.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Open Link New Tab -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_open_link_new_tab_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-open-link-new-tab"><?php esc_html_e('Open Link New Tab', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-open-link-new-tab">
                                <option value="0" selected="selected"><?php esc_html_e('No', 'dalt'); ?></option>
                                <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Select if the link should be opened in a new tab.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Image Left -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_left_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-left"><?php esc_html_e('Image Left', 'dalt'); ?></label>
                        </th>
                        <td>

                            <div class="image-uploader">
                                <div class="image-container">
                                    <img class="selected-image" src="" style="display: none">
                                </div>
                                <input type="hidden" id="cell-property-image-left" maxlength="2083">
                                <a class="button_add_media" data-set-remove="set"
                                   data-set="<?php esc_attr_e('Set image', 'dalt'); ?>"
                                   data-remove="<?php esc_attr_e('Remove Image', 'dalt'); ?>"><?php esc_html_e('Set image', 'dalt'); ?></a>
                                <p class="description"><?php esc_attr_e('Select an image that should be placed on the left of the text.', 'dalt'); ?></p>
                            </div>

                        </td>
                    </tr>

                    <!-- Image Left Link -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_left_link_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-left-link"><?php esc_html_e('Image Left Link', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="2083" type="text" id="cell-property-image-left-link" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Enter an URL to link the image on the left to a specific destination.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Image Left Open Link New Tab -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_left_open_link_new_tab_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-left-open-link-new-tab"><?php esc_html_e('Image Left Open Link New Tab', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-image-left-open-link-new-tab">
                                <option value="0" selected="selected"><?php esc_html_e('No', 'dalt'); ?></option>
                                <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Select if the link associated with the image on the left should be opened in a new tab.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Image Right -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_right_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-right"><?php esc_html_e('Image Right', 'dalt'); ?></label>
                        </th>
                        <td>

                            <div class="image-uploader">
                                <div class="image-container">
                                    <img class="selected-image" src="" style="display: none">
                                </div>
                                <input type="hidden" id="cell-property-image-right" maxlength="2083">
                                <a class="button_add_media" data-set-remove="set"
                                   data-set="<?php esc_attr_e('Set image', 'dalt'); ?>"
                                   data-remove="<?php esc_attr_e('Remove Image', 'dalt'); ?>"><?php esc_html_e('Set image', 'dalt'); ?></a>
                                <p class="description"><?php esc_html_e('Select an image that should be placed on the right of the text.', 'dalt'); ?></p>
                            </div>

                        </td>
                    </tr>

                    <!-- Image Right Link -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_right_link_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-right-link"><?php esc_html_e('Image Right Link', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="2083" type="text" id="cell-property-image-right-link" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Enter an URL to link the image on right to a specific destination.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Image Right Open Link New Tab -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_image_right_open_link_new_tab_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-image-right-open-link-new-tab"><?php esc_html_e('Image Right Open Link New Tab', 'dalt'); ?></label>
                        </th>
                        <td>
                            <select id="cell-property-image-right-open-link-new-tab">
                                <option value="0" selected="selected"><?php esc_html_e('No', 'dalt'); ?></option>
                                <option value="1"><?php esc_html_e('Yes', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Select if the link associated with the image on the right should be opened in a new tab.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Formula -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_formula_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-formula"><?php esc_html_e('Formula', 'dalt'); ?></label></th>
                        <td>
                            <select id="cell-property-formula">
                                <option value="sum" selected="selected"><?php esc_html_e('Sum', 'dalt'); ?></option>
                                <option value="subtrac"><?php esc_html_e('Subtraction', 'dalt'); ?></option>
                                <option value="minimum"><?php esc_html_e('Minimum', 'dalt'); ?></option>
                                <option value="maximum"><?php esc_html_e('Maximum', 'dalt'); ?></option>
                                <option value="average"><?php esc_html_e('Average', 'dalt'); ?></option>
                            </select>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Select which operation should be applied on the indexes provided in "Formula Data".', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Formula Data -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_formula_data_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-formula-data"><?php esc_html_e('Formula Data', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="110" type="text" id="cell-property-formula-data" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Enter a list of column indexes, separated by a comma, where the formula should be applied. Please note that if you use this option the cell content will be ignored.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- HTML Content -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_html_content_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-html-content"><?php esc_html_e('HTML Content', 'dalt'); ?></label>
                        </th>
                        <td>
                            <textarea id="cell-property-html-content" maxlength="65535"></textarea>
                            <div class="help-icon"
                                 title="<?php esc_attr_e('Use this field to include custom HTML content in the cell. Please note that if you use this option the cell content and most of the cell properties associated with this cell will be ignored.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Row Slots -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_row_slots_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-row-slots"><?php esc_html_e('Row Slots', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="5" type="text" id="cell-property-row-slots" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The number of row slots occupied by the cell. Please note that this cell property is used only if the sorting is disabled.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    <!-- Column Slots -->
                    <tr class="cell-property<?php if(intval(get_option($this->shared->get('slug') . "_enable_column_slots_cell_property"), 10) === 0){echo ' display-none';} ?>">
                        <th><label
                                    for="cell-property-column-slots"><?php esc_html_e('Column Slots', 'dalt'); ?></label>
                        </th>
                        <td>
                            <input maxlength="4" type="text" id="cell-property-column-slots" autocomplete="off">
                            <div class="help-icon"
                                 title="<?php esc_attr_e('The number of column slots occupied by the cell. Please note that this cell property is used only if the sorting is disabled.', 'dalt'); ?>"></div>
                        </td>
                    </tr>

                    </tbody>

                </table>

                <!-- submit button -->
                <div class="daext-form-action">
                    <input id="update-cell-properties" data-action="" class="update-reset-cell-properties button"
                           type="submit" value="">
                    <input id="reset-cell-properties" class="update-reset-cell-properties button" type="submit"
                           value="<?php esc_attr_e('Reset Cell Properties', 'dalt'); ?>">
                </div>

            </div>

            <div id="cell-properties-error-message" class="error settings-error notice below-h2"><p></p></div>
            <div id="cell-properties-added-updated-message" class="updated settings-error notice below-h2"><p></p></div>

        </div>

    </div>

    <!-- Dialog Keyboard Shortcut -->
    <div class="dialog-alert" data-id="dialog-keyboard-shortcut" title="<?php esc_attr_e('Please use the keyboard shortcut', 'dalt'); ?>" class="daext-display-none">
        <p><?php esc_html_e('Due to security reason, modern browsers disallow to read from the system clipboard:', 'dalt'); ?></p>
        <p><?php echo 'https://www.w3.org/TR/clipboard-apis/#privacy'; ?></p>
        <p><?php esc_html_e('Please use Ctrl+V (Windows/Linux) or Command+V (Mac) to perform this operation.', 'dalt'); ?></p>
    </div>

    <!-- Valid Cell Number -->
    <div class="dialog-alert" data-id="valid-cell-number" title="<?php esc_attr_e('Please reduce the number of select cells', 'dalt'); ?>" class="daext-display-none">
        <p><?php esc_html_e('For performance reasons, the maximum number of cells allowed in this context menu operation is equal to 100.', 'dalt'); ?></p>
        <p><?php esc_html_e('Please reduce the number of selected cells to perform this operation.', 'dalt'); ?></p>
    </div>

    <!-- Specific Shortcut Disabled -->
    <div class="dialog-alert" data-id="specific-shortcut-disabled" title="<?php esc_attr_e('Please use the context menu', 'dalt'); ?>" class="daext-display-none">
        <p><?php esc_html_e('Specific keyboard shortcuts are disabled on the spreadsheet editor.', 'dalt'); ?></p>
        <p><?php esc_html_e('Please click the right mouse button and use the context menu.', 'dalt'); ?></p>
    </div>

    <!-- Dialog Confirm -->
    <div id="dialog-confirm" title="<?php esc_attr_e('Delete the table?', 'dalt'); ?>" class="display-none">
        <p><?php esc_html_e('This table will be permanently deleted and cannot be recovered. Are you sure?',
				'dalt'); ?></p>
    </div>